<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;


class NewVerifyFactorList extends ListResource
    {
    /**
     * Construct the NewVerifyFactorList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The unique SID identifier of the Service.
     */
    public function __construct(
        Version $version,
        string $serviceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Passkeys/VerifyFactor';
    }

    /**
     * Update the NewVerifyFactorInstance
     *
     * @param VerifyPasskeysFactorRequest $verifyPasskeysFactorRequest
     * @return NewVerifyFactorInstance Updated NewVerifyFactorInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(VerifyPasskeysFactorRequest $verifyPasskeysFactorRequest): NewVerifyFactorInstance
    {

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $verifyPasskeysFactorRequest->toArray();
        $payload = $this->version->update('POST', $this->uri, [], $data, $headers);

        return new NewVerifyFactorInstance(
            $this->version,
            $payload,
            $this->solution['serviceSid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Verify.V2.NewVerifyFactorList]';
    }
}
