<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() === 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(app()->getLocale() === 'ar' ? 'بيانات تسجيل الدخول' : 'Login Credentials'); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #2c3e50;
            margin: 0;
        }
        .content {
            margin-bottom: 30px;
        }
        .credentials-box {
            background-color: #f8f9fa;
            border: 2px solid #007bff;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .credential-item {
            margin: 15px 0;
            padding: 10px;
            background-color: #ffffff;
            border-left: 4px solid #007bff;
        }
        .credential-label {
            font-weight: bold;
            color: #495057;
            margin-bottom: 5px;
        }
        .credential-value {
            font-size: 18px;
            color: #007bff;
            word-break: break-all;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #007bff;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
            text-align: center;
        }
        .button:hover {
            background-color: #0056b3;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 12px;
        }
        .warning {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php echo e(app()->getLocale() === 'ar' ? 'بيانات تسجيل الدخول' : 'Login Credentials'); ?></h1>
        </div>
        
        <div class="content">
            <?php if(app()->getLocale() === 'ar'): ?>
                <p>مرحباً <?php echo e($userName ?? ''); ?>,</p>
                <p>تم إنشاء حساب جديد لك في النظام. يمكنك استخدام البيانات التالية لتسجيل الدخول:</p>
            <?php else: ?>
                <p>Hello <?php echo e($userName ?? ''); ?>,</p>
                <p>A new account has been created for you. You can use the following credentials to login:</p>
            <?php endif; ?>
            
            <div class="credentials-box">
                <div class="credential-item">
                    <div class="credential-label"><?php echo e(app()->getLocale() === 'ar' ? 'البريد الإلكتروني:' : 'Email:'); ?></div>
                    <div class="credential-value"><?php echo e($email); ?></div>
                </div>
                
                <div class="credential-item">
                    <div class="credential-label"><?php echo e(app()->getLocale() === 'ar' ? 'كلمة المرور:' : 'Password:'); ?></div>
                    <div class="credential-value"><?php echo e($password); ?></div>
                </div>
            </div>
            
            <?php if($loginUrl): ?>
                <div style="text-align: center;">
                    <a href="<?php echo e($loginUrl); ?>" class="button">
                        <?php echo e(app()->getLocale() === 'ar' ? 'تسجيل الدخول' : 'Login'); ?>

                    </a>
                </div>
            <?php endif; ?>
            
            <div class="warning">
                <?php if(app()->getLocale() === 'ar'): ?>
                    <strong>تنبيه:</strong> يرجى تغيير كلمة المرور بعد تسجيل الدخول لأول مرة. لا تشارك هذه البيانات مع أي شخص.
                <?php else: ?>
                    <strong>Warning:</strong> Please change your password after your first login. Do not share these credentials with anyone.
                <?php endif; ?>
            </div>
        </div>
        
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. <?php echo e(app()->getLocale() === 'ar' ? 'جميع الحقوق محفوظة' : 'All rights reserved'); ?>.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\2025\Ejarah\Ejar\website\resources\views/emails/user-credentials.blade.php ENDPATH**/ ?>