<!DOCTYPE html>
<html lang="<?php echo e($currentLocale ?? 'ar'); ?>" dir="<?php echo e(($currentLocale ?? 'ar') === 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>موقع تخليص عقود الإيجار - إيجاره</title>
  <link rel="stylesheet" href="<?php echo e(asset('website/styles.css')); ?>" />
  <script src="https://unpkg.com/lucide@latest"></script>
  <script src="<?php echo e(asset('website/translations.js')); ?>"></script>
  <script src="<?php echo e(asset('website/app.js')); ?>"></script>
  <script>
     window.addEventListener('load', function() {
      if (typeof lucide !== 'undefined' && lucide.createIcons) {
        lucide.createIcons();
      }
    });
  </script>
</head>
<body>
  <!-- Header -->
  <header>
    <div class="header-container container">
      <div class="logo">
        <a href="<?php echo e(route('home')); ?>">
          <img src="<?php echo e(asset('website/assets/4d2b6a0c0a4f0e90f29a6eb33665df8523df6e9b.png')); ?>" alt="Ijarah Logo" />
        </a>
      </div>
      
      <nav>
        <a href="<?php echo e(route('home')); ?>" data-translate="home">الرئيسية</a>
        <a href="#services" data-translate="services">الخدمات</a>
        <a href="#features" data-translate="features">المميزات</a>
        <a href="#how-it-works" data-translate="howItWorks">كيف نعمل</a>
        <a href="#about" data-translate="about">من نحن</a>
        <a href="#faq" data-translate="faq">الأسئلة الشائعة</a>
        <a href="#contact" data-translate="contact">تواصل معنا</a>
      </nav>
      
      <div class="header-actions">
        <button id="language-toggle" class="language-toggle">
          <i data-lucide="globe"></i>
          <span>EN</span>
        </button>
        <a href="<?php echo e(route('verify')); ?>" class="btn-primary" data-translate="verifyContract">التحقق من عقد</a>
      </div>
      
      <button id="mobile-menu-toggle" class="mobile-menu-toggle">
        <i data-lucide="menu"></i>
      </button>
    </div>
    
    <div id="mobile-menu" class="mobile-menu hidden">
      <a href="#home" data-translate="home">الرئيسية</a>
      <a href="#services" data-translate="services">الخدمات</a>
      <a href="#features" data-translate="features">المميزات</a>
      <a href="#how-it-works" data-translate="howItWorks">كيف نعمل</a>
      <a href="#about" data-translate="about">من نحن</a>
      <a href="#faq" data-translate="faq">الأسئلة الشائعة</a>
      <a href="#contact" data-translate="contact">تواصل معنا</a>
      <div style="padding: 1rem; border-top: 1px solid var(--gray-100); margin-top: 1rem;">
        <button id="mobile-language-toggle" class="language-toggle" style="width: 100%; justify-content: center;">
          <i data-lucide="globe"></i>
          <span>EN</span>
        </button>
      </div>
      <a href="<?php echo e(route('verify')); ?>" class="btn-primary" style="display: block; text-align: center; margin-top: 1rem;" data-translate="verifyContract">التحقق من عقد</a>
    </div>
  </header>
 
 <?php echo $__env->yieldContent('content'); ?>

  <!-- Footer -->
  <footer>
    <div class="container">
      <div class="footer-main">
        <!-- Company Info - Centered -->
        <div class="footer-company-info">
          <img src="<?php echo e(asset('website/assets/4d2b6a0c0a4f0e90f29a6eb33665df8523df6e9b.png')); ?>" alt="Ijarah Logo" class="footer-logo" />
          <p class="footer-description" data-translate="footerDescription">نقدم خدمات متكاملة لتخليص وإدارة عقود الإيجار بطريقة قانونية سليمة وسريعة.</p>
          <div class="footer-social">
            <a href="#" class="footer-social-link">
              <i data-lucide="facebook"></i>
            </a>
            <a href="#" class="footer-social-link">
              <i data-lucide="twitter"></i>
            </a>
            <a href="#" class="footer-social-link">
              <i data-lucide="instagram"></i>
            </a>
            <a href="#" class="footer-social-link">
              <i data-lucide="linkedin"></i>
            </a>
          </div>
        </div>
        
       
      </div>
      
      <!-- Bottom Bar -->
      <div class="footer-bottom">
        <p class="footer-copyright">
          © <span id="current-year"></span> <span data-translate="allRightsReserved">إيجاره - جميع الحقوق محفوظة</span>
        </p>
        <div class="footer-links">
          <a href="<?php echo e(route('privacyPolicy')); ?>" data-translate="privacyPolicy">سياسة الخصوصية</a>
          <a href="<?php echo e(route('terms')); ?>" data-translate="termsConditions">الشروط والأحكام</a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Scroll to Top Button -->
  <button id="scroll-to-top" class="hidden">
    <i data-lucide="arrow-up"></i>
  </button>

  <script>
    lucide.createIcons();
    document.getElementById('current-year').textContent = new Date().getFullYear();
  </script>
</body>
</html>
<?php /**PATH D:\2025\Ejarah\Ejar\website\resources\views/website/layout/master.blade.php ENDPATH**/ ?>