<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() === 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(app()->getLocale() === 'ar' ? 'إعادة تعيين كلمة المرور' : 'Reset Password'); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #2c3e50;
            margin: 0;
        }
        .content {
            margin-bottom: 30px;
        }
        .otp-code {
            background-color: #f8f9fa;
            border: 2px dashed #007bff;
            padding: 20px;
            text-align: center;
            margin: 20px 0;
            border-radius: 5px;
        }
        .otp-code span {
            font-size: 32px;
            font-weight: bold;
            color: #007bff;
            letter-spacing: 5px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 12px;
        }
        .warning {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php echo e(app()->getLocale() === 'ar' ? 'إعادة تعيين كلمة المرور' : 'Reset Password'); ?></h1>
        </div>
        
        <div class="content">
            <?php if(app()->getLocale() === 'ar'): ?>
                <p>مرحباً <?php echo e($userName ?? ''); ?>,</p>
                <p>لقد طلبت إعادة تعيين كلمة المرور لحسابك. استخدم الكود التالي لإعادة تعيين كلمة المرور:</p>
            <?php else: ?>
                <p>Hello <?php echo e($userName ?? ''); ?>,</p>
                <p>You have requested to reset your password. Use the following code to reset your password:</p>
            <?php endif; ?>
            
            <div class="otp-code">
                <span><?php echo e($otpCode); ?></span>
            </div>
            
            <div class="warning">
                <?php if(app()->getLocale() === 'ar'): ?>
                    <strong>تنبيه:</strong> هذا الكود صالح لمدة 15 دقيقة فقط. لا تشارك هذا الكود مع أي شخص.
                <?php else: ?>
                    <strong>Warning:</strong> This code is valid for 15 minutes only. Do not share this code with anyone.
                <?php endif; ?>
            </div>
            
            <?php if(app()->getLocale() === 'ar'): ?>
                <p>إذا لم تطلب إعادة تعيين كلمة المرور، يرجى تجاهل هذا البريد الإلكتروني.</p>
            <?php else: ?>
                <p>If you did not request a password reset, please ignore this email.</p>
            <?php endif; ?>
        </div>
        
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. <?php echo e(app()->getLocale() === 'ar' ? 'جميع الحقوق محفوظة' : 'All rights reserved'); ?>.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\2025\Ejarah\Ejar\website\resources\views/emails/reset-password.blade.php ENDPATH**/ ?>