<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\WebsiteController;

// Route لتبديل اللغة
Route::get('/switch-language/{locale}', function ($locale) {
    $supportedLocales = ['ar', 'en'];
    
    if (in_array($locale, $supportedLocales)) {
        Session::put('locale', $locale);
    }
    
    return redirect()->back();
})->name('switch-language');

// المسارات العادية (middleware سيتعامل مع اللغة)
Route::get('/', [WebsiteController::class, 'home'])->name('home');
Route::get('/terms', [WebsiteController::class, 'terms'])->name('terms');
Route::get('/privacy-policy', [WebsiteController::class, 'privacyPolicy'])->name('privacyPolicy');
Route::get('/verify', [WebsiteController::class, 'verify'])->name('verify');
Route::get('/contract', [WebsiteController::class, 'contract'])->name('contract');