@extends('website.layout.master')
@section('content')
  <!-- Hero Section -->
  <section id="home" class="hero">
    <!-- Background Gradient -->
    <div class="hero-bg-gradient"></div>
    
    <!-- Decorative Elements -->
    <div class="hero-decorative-1"></div>
    <div class="hero-decorative-2"></div>
    
    <div class="container">
      <div class="hero-content">
        <div class="hero-text">
          <!-- Badge -->
          <div class="hero-badge">
            <div class="hero-badge-dot"></div>
            <span data-translate="trustedBy">موثوق من قبل +500 عميل</span>
          </div>
          
          <h1 class="hero-title">
            <span class="hero-title-line1" data-translate="heroTitle1">إدارة عقود الإيجار</span>
            <span class="hero-title-line2" data-translate="heroTitle2">بكل سهولة واحترافية</span>
          </h1>
          
          <p class="hero-description">
            <span data-translate="heroDescription">نوفر لك حلولاً متكاملة لتخليص وتوثيق عقود الإيجار بطريقة قانونية آمنة وسريعة.</span>
            <span class="hero-description-highlight" data-translate="heroDescriptionHighlight">وفّر وقتك واحمِ حقوقك معنا</span>
          </p>
          
          <!-- CTA Buttons -->
          <div class="hero-cta">
            <a href="#contact" class="hero-btn-primary" data-translate="startNowFree">
              <span>ابدأ الآن مجاناً</span>
              <i data-lucide="arrow-left"></i>
            </a>
            <a href="#services" class="hero-btn-secondary" data-translate="discoverServices">
              <i data-lucide="file-text"></i>
              <span>اكتشف خدماتنا</span>
            </a>
          </div>
          
          <!-- Trust Indicators -->
          <div class="hero-stats">
            <div class="hero-stat">
              <div class="hero-stat-icon hero-stat-icon-green">
                <i data-lucide="check-circle"></i>
              </div>
              <div class="hero-stat-number">+{{ $generalInfo->contracts_counter ?? '0' }}</div>
              <div class="hero-stat-label" data-translate="completedContracts">عقد مكتمل</div>
            </div>
            <div class="hero-stat">
              <div class="hero-stat-icon hero-stat-icon-blue">
                <i data-lucide="clock"></i>
              </div>
              <div class="hero-stat-number">{{ $generalInfo->support_time ?? '24' }}</div>
              <div class="hero-stat-label" data-translate="deliveryTime">ساعة تسليم</div>
            </div>
            <div class="hero-stat">
              <div class="hero-stat-icon hero-stat-icon-gold">
                <i data-lucide="shield"></i>
              </div>
              <div class="hero-stat-number">100%</div>
              <div class="hero-stat-label" data-translate="safeProtected">آمن ومحمي</div>
            </div>
          </div>
        </div>
        
        <!-- Image Section -->
        <div class="hero-image-container">
          <!-- Background Card -->
          <div class="hero-image-bg-card"></div>
          
          <!-- Main Image Card -->
          <div class="hero-image-card">
            <img src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=800&q=80" alt="Contract Management" class="hero-image" />
            <div class="hero-image-overlay"></div>
            
            <!-- Floating Card 1 - Success Rate -->
            <div class="hero-floating-card hero-floating-card-1">
              <div class="hero-floating-card-content">
                <div class="hero-floating-icon hero-floating-icon-green">
                  <i data-lucide="check-circle"></i>
                </div>
                <div>
                  <div class="hero-floating-number">98%</div>
                  <div class="hero-floating-label" data-translate="successRate">نسبة النجاح</div>
                </div>
              </div>
            </div>
            
            <!-- Floating Card 2 - Quick Process -->
            <div class="hero-floating-card hero-floating-card-2">
              <div class="hero-floating-card-content">
                <i data-lucide="clock" class="hero-floating-clock-icon"></i>
                <div>
                  <div class="hero-floating-text" data-translate="quickProcess">إنجاز سريع</div>
                  <div class="hero-floating-title" data-translate="within24Hours">خلال 24 ساعة</div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Decorative Dots -->
          <div class="hero-decorative-dots"></div>
          
          <!-- Decorative Circle -->
          <div class="hero-decorative-circle"></div>
        </div>
      </div>
    </div>
  </section>

  <!-- Services Section -->
  <section id="services" class="services-section">
    <div class="container">
      <div class="section-header">
        <div class="section-badge" data-translate="ourServices">خدماتنا</div>
        <h2 class="section-title" data-translate="whatWeOffer">ما نقدمه لك</h2>
        <p class="section-description" data-translate="servicesDescription">مجموعة شاملة من الخدمات المتخصصة في تخليص وإدارة عقود الإيجار</p>
      </div>
      
      <div class="services-grid">
        @php
          $services = app()->getLocale() == 'ar' ? ($generalInfo->services_ar ?? []) : ($generalInfo->services_en ?? []);
          $colors = [
            ['#3b82f6', '#2563eb'],
            ['var(--primary-gold)', 'var(--primary-gold-dark)'],
            ['var(--primary-blue)', 'var(--primary-blue-dark)'],
            ['#14b8a6', '#0d9488'],
            ['#a855f7', '#9333ea'],
            ['#f97316', '#ea580c']
          ];
          $icons = ['file-check', 'file-edit', 'shield', 'clock', 'users', 'briefcase'];
        @endphp
        @forelse($services as $index => $service)
          <div class="service-card">
            <div class="service-icon" style="background: linear-gradient(to bottom right, {{ $colors[$index % count($colors)][0] }}, {{ $colors[$index % count($colors)][1] }});">
              <i data-lucide="{{ $icons[$index % count($icons)] }}"></i>
            </div>
            <h3 class="service-title">{{ $service['name'] ?? '' }}</h3>
            <p class="service-description">{{ $service['description'] ?? '' }}</p>
          </div>
        @empty
          {{-- Default services if none exist --}}
          <div class="service-card">
            <div class="service-icon" style="background: linear-gradient(to bottom right, #3b82f6, #2563eb);">
              <i data-lucide="file-check"></i>
            </div>
            <h3 class="service-title" data-translate="contractPreparation">إعداد العقود</h3>
            <p class="service-description" data-translate="contractPreparationDesc">نقوم بإعداد عقود الإيجار وفق الأنظمة والقوانين المعتمدة بشكل دقيق واحترافي</p>
          </div>
        @endforelse
      </div>
    </div>
  </section>

  <!-- Features Section -->
  <section id="features" class="features-section">
    <div class="container">
      <div class="features-grid">
        <!-- Content -->
        <div class="features-content">
          <div class="features-badge" data-translate="whyUs">لماذا نحن</div>
          <h2 class="features-title" data-translate="featuresTitle">مميزاتنا التي تجعلنا الخيار الأفضل</h2>
          <p class="features-description" data-translate="featuresDescription">نحن نلتزم بتقديم خدمات عالية الجودة تتميز بالاحترافية والسرعة والدقة في التنفيذ</p>
          
          <div class="features-list">
            @php
              $features = app()->getLocale() == 'ar' ? ($generalInfo->features_ar ?? []) : ($generalInfo->features_en ?? []);
              $featureIcons = ['zap', 'award', 'check-circle', 'headphones', 'shield', 'trending-up'];
            @endphp
            @forelse($features as $index => $feature)
              <div class="feature-item">
                <div class="feature-icon-wrapper">
                  <i data-lucide="{{ $featureIcons[$index % count($featureIcons)] }}" class="feature-icon"></i>
                </div>
                <div>
                  <h3 class="feature-title">{{ $feature['title'] ?? $feature['name'] ?? '' }}</h3>
                  <p class="feature-description">{{ $feature['description'] ?? '' }}</p>
                </div>
              </div>
            @empty
              {{-- Default features if none exist --}}
              <div class="feature-item">
                <div class="feature-icon-wrapper">
                  <i data-lucide="zap" class="feature-icon"></i>
                </div>
                <div>
                  <h3 class="feature-title" data-translate="speedOfCompletion">سرعة في الإنجاز</h3>
                  <p class="feature-description" data-translate="speedOfCompletionDesc">نضمن لك إنهاء جميع الإجراءات في أسرع وقت ممكن دون تأخير</p>
                </div>
              </div>
            @endforelse
          </div>
        </div>
        
        <!-- Visual -->
        <div class="features-visual">
          <div class="stats-grid-visual">
            <div class="stat-card-visual stat-card-1">
              <div class="stat-number">+{{ $generalInfo->contracts_counter ?? '0' }}</div>
              <div class="stat-label" data-translate="contractsCompleted">عقد تم تخليصه بنجاح</div>
            </div>
            <div class="stat-card-visual stat-card-2">
              <div class="stat-number">{{ $generalInfo->experience_years ?? '0' }}+</div>
              <div class="stat-label" data-translate="yearsOfExperience">سنوات من الخبرة</div>
            </div>
            <div class="stat-card-visual stat-card-3">
              <div class="stat-number">{{ $generalInfo->happy_clients ?? '0' }}%</div>
              <div class="stat-label" data-translate="clientSatisfaction">نسبة رضا العملاء</div>
            </div>
            <div class="stat-card-visual stat-card-4">
              <div class="stat-number">24/7</div>
              <div class="stat-label" data-translate="support247">دعم على مدار الساعة</div>
            </div>
          </div>
          
          <!-- Decorative Elements -->
          <div class="decorative-element decorative-1"></div>
          <div class="decorative-element decorative-2"></div>
        </div>
      </div>
    </div>
  </section>

  <!-- How It Works Section -->
  <section id="how-it-works" class="how-it-works-section">
    <div class="container">
      <div class="section-header">
        <div class="section-badge" data-translate="howWeWork">كيف نعمل</div>
        <h2 class="section-title" data-translate="simpleStepsTitle">خطوات بسيطة للحصول على خدماتنا</h2>
        <p class="section-description" data-translate="simpleStepsDescription">نجعل عملية تخليص عقود الإيجار سهلة ومريحة من خلال أربع خطوات بسيطة</p>
      </div>
      
      <div class="steps-container">
        <!-- Connection Line - Desktop -->
        <div class="steps-connection-line"></div>
        
        <div class="steps-grid">
          @php
            $workingSteps = app()->getLocale() == 'ar' ? ($generalInfo->working_steps_ar ?? []) : ($generalInfo->working_steps_en ?? []);
            $stepIcons = ['message-square', 'file-search', 'pen-tool', 'check-circle-2'];
          @endphp
          @forelse($workingSteps as $index => $step)
            <div class="step-item">
              <div class="step-icon-wrapper">
                <div class="step-icon-circle">
                  <i data-lucide="{{ $stepIcons[$index % count($stepIcons)] }}" class="step-icon"></i>
                </div>
                <div class="step-number-badge">{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</div>
                <div class="step-pulse" style="animation-delay: {{ $index * 0.5 }}s;"></div>
              </div>
              <h3 class="step-title">{{ $step['title'] ?? $step['name'] ?? '' }}</h3>
              <p class="step-description">{{ $step['description'] ?? '' }}</p>
              @if($index < count($workingSteps) - 1)
                <!-- Arrow - Desktop -->
                <div class="step-arrow">
                  <svg width="30" height="30" viewBox="0 0 30 30" fill="none">
                    <path d="M15 5L10 15H20L15 5Z" fill="currentColor" />
                  </svg>
                </div>
              @endif
            </div>
          @empty
            {{-- Default steps if none exist --}}
            <div class="step-item">
              <div class="step-icon-wrapper">
                <div class="step-icon-circle">
                  <i data-lucide="message-square" class="step-icon"></i>
                </div>
                <div class="step-number-badge">01</div>
                <div class="step-pulse"></div>
              </div>
              <h3 class="step-title" data-translate="contactUs">تواصل معنا</h3>
              <p class="step-description" data-translate="contactUsDesc">ابدأ بالتواصل معنا عبر الهاتف أو النموذج الإلكتروني وشارك معنا تفاصيل طلبك</p>
            </div>
          @endforelse
        </div>
        
        <div class="steps-cta">
          <a href="#contact" class="btn-primary" data-translate="startNowWithUs">ابدأ الآن معنا</a>
        </div>
      </div>
    </div>
  </section>

  <!-- About Us Section -->
  <section id="about" class="about-section">
    <div class="container">
      <div class="section-header">
        <div class="section-badge" data-translate="aboutUs">من نحن</div>
        <h2 class="section-title" data-translate="aboutIjarahTitle">نبذة عن إيجاره</h2>
        <p class="section-description" data-translate="aboutIjarahDescription">منصة رائدة في مجال تخليص وإدارة عقود الإيجار، نقدم حلولاً متكاملة تجمع بين الخبرة القانونية والتقنية الحديثة</p>
      </div>
      
      <div class="story-stats-grid">
        <div class="story-content">
          <h3 style="font-size: 1.5rem; font-weight: 600; color: var(--gray-900); margin-bottom: 1.5rem;" data-translate="ourStory">قصتنا</h3>
          <div class="story-text">
            @php
              $aboutUs = app()->getLocale() == 'ar' ? ($generalInfo->about_us_ar ?? '') : ($generalInfo->about_us_en ?? '');
            @endphp
            @if($aboutUs)
               {!! $aboutUs !!} 
            @else
              <p data-translate="storyParagraph1">انطلقت "إيجاره" من رؤية واضحة: تسهيل عملية تخليص عقود الإيجار وجعلها أكثر شفافية وأماناً للجميع. نحن نؤمن بأن كل عملية إيجار يجب أن تكون محمية قانونياً وموثقة بشكل صحيح.</p>
              <p data-translate="storyParagraph2">مع مرور السنوات، نجحنا في بناء سمعة قوية في السوق من خلال تقديم خدمات عالية الجودة والتزامنا الدائم برضا عملائنا. فريقنا المتخصص يعمل بشكل دؤوب لضمان أن كل عقد يتم إعداده بأعلى معايير الدقة والاحترافية.</p>
              <p data-translate="storyParagraph3">اليوم، نفخر بكوننا الخيار الأول للعديد من الأفراد والشركات الذين يبحثون عن خدمات موثوقة في مجال عقود الإيجار.</p>
            @endif
          </div>
        </div>
        
        <div class="stats-grid-2x2">
          <div class="stat-card">
            <div style="font-size: 1.875rem; font-weight: 700; margin-bottom: 0.5rem;">{{ $generalInfo->contracts_counter ?? '0' }}+</div>
            <div style="font-size: 0.875rem; opacity: 0.9;" data-translate="contractsDone">عقد تم إنجازه</div>
          </div>
          <div class="stat-card">
            <div style="font-size: 1.875rem; font-weight: 700; margin-bottom: 0.5rem;">{{ $generalInfo->happy_clients ?? '0' }}%</div>
            <div style="font-size: 0.875rem; opacity: 0.9;" data-translate="satisfactionRate">نسبة رضا العملاء</div>
          </div>
          <div class="stat-card">
            <div style="font-size: 1.875rem; font-weight: 700; margin-bottom: 0.5rem;">{{ $generalInfo->experience_years ?? '0' }}+</div>
            <div style="font-size: 0.875rem; opacity: 0.9;" data-translate="experienceYears">سنوات من الخبرة</div>
          </div>
          <div class="stat-card">
            <div style="font-size: 1.875rem; font-weight: 700; margin-bottom: 0.5rem;">{{ $generalInfo->success_partners ?? '0' }}+</div>
            <div style="font-size: 0.875rem; opacity: 0.9;" data-translate="successPartners">شريك نجاح</div>
          </div>
        </div>
      </div>
      
      <div class="vision-mission-grid">
        <div class="vision-card">
          <div style="width: 3.5rem; height: 3.5rem; background: rgba(255, 255, 255, 0.2); border-radius: 0.75rem; display: flex; align-items: center; justify-content: center; margin-bottom: 1.5rem;">
            <i data-lucide="eye" style="color: white; width: 32px; height: 32px;"></i>
          </div>
          <h3 style="font-size: 1.5rem; font-weight: 600; margin-bottom: 1rem;" data-translate="ourVision">رؤيتنا</h3>
          <p style="color: rgba(255, 255, 255, 0.9); line-height: 1.75;">
            @php
              $vision = app()->getLocale() == 'ar' ? ($generalInfo->vision_ar ?? '') : ($generalInfo->vision_en ?? '');
              echo $vision ?: (app()->getLocale() == 'ar' ? 'أن نكون المنصة الأولى والأكثر ثقة في المملكة العربية السعودية لتخليص وإدارة عقود الإيجار، من خلال تقديم خدمات متميزة تجمع بين الخبرة القانونية والتقنية المتطورة، مع الحفاظ على أعلى معايير الجودة والشفافية.' : 'To be the first and most trusted platform in the Kingdom of Saudi Arabia for processing and managing rental contracts, through providing distinguished services that combine legal expertise and advanced technology, while maintaining the highest standards of quality and transparency.');
            @endphp
          </p>
        </div>
        
        <div class="mission-card">
          <div style="width: 3.5rem; height: 3.5rem; background: rgba(255, 255, 255, 0.2); border-radius: 0.75rem; display: flex; align-items: center; justify-content: center; margin-bottom: 1.5rem;">
            <i data-lucide="target" style="color: white; width: 32px; height: 32px;"></i>
          </div>
          <h3 style="font-size: 1.5rem; font-weight: 600; margin-bottom: 1rem;" data-translate="ourMission">رسالتنا</h3>
          <p style="color: rgba(255, 255, 255, 0.9); line-height: 1.75;">
            @php
              $message = app()->getLocale() == 'ar' ? ($generalInfo->message_ar ?? '') : ($generalInfo->message_en ?? '');
              echo $message ?: (app()->getLocale() == 'ar' ? 'نسعى لتبسيط عملية تخليص عقود الإيجار وجعلها أكثر سهولة وأماناً للجميع، من خلال فريق متخصص وعمليات واضحة وشفافة. نلتزم بحماية حقوق عملائنا وتقديم استشارات قانونية موثوقة، مع ضمان الامتثال الكامل للأنظمة والقوانين المعتمدة.' : 'We seek to simplify the process of processing rental contracts and make it easier and safer for everyone, through a specialized team and clear and transparent processes. We are committed to protecting our clients\' rights and providing reliable legal consultations, while ensuring full compliance with approved regulations and laws.');
            @endphp
          </p>
        </div>
      </div>
      
      <div>
        <div style="text-align: center; margin-bottom: 3rem;">
          <h3 style="font-size: 1.5rem; font-weight: 600; color: var(--gray-900); margin-bottom: 1rem;" data-translate="ourValues">قيمنا</h3>
          <p style="color: var(--gray-600); max-width: 42rem; margin: 0 auto;" data-translate="valuesDescription">القيم التي نؤمن بها وتوجه عملنا اليومي</p>
        </div>
        
        <div class="values-grid">
          @php
            $values = app()->getLocale() == 'ar' ? ($generalInfo->values_ar ?? []) : ($generalInfo->values_en ?? []);
            $valueIcons = ['check-circle', 'users', 'award', 'trending-up'];
          @endphp
          @forelse($values as $index => $value)
            <div style="background: white; border: 1px solid var(--gray-100); border-radius: 1rem; padding: 1.5rem; text-align: center; transition: all 0.3s;">
              <div style="width: 3.5rem; height: 3.5rem; background: linear-gradient(to bottom right, var(--primary-blue), var(--primary-blue-dark)); border-radius: 0.75rem; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                <i data-lucide="{{ $valueIcons[$index % count($valueIcons)] }}" style="color: white; width: 28px; height: 28px;"></i>
              </div>
              <h4 style="font-size: 1.125rem; font-weight: 600; color: var(--gray-900); margin-bottom: 0.5rem;">{{ $value['title'] ?? $value['name'] ?? '' }}</h4>
              <p style="color: var(--gray-600); font-size: 0.875rem;">{{ $value['description'] ?? '' }}</p>
            </div>
          @empty
            {{-- Default values if none exist --}}
            <div style="background: white; border: 1px solid var(--gray-100); border-radius: 1rem; padding: 1.5rem; text-align: center; transition: all 0.3s;">
              <div style="width: 3.5rem; height: 3.5rem; background: linear-gradient(to bottom right, var(--primary-blue), var(--primary-blue-dark)); border-radius: 0.75rem; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                <i data-lucide="check-circle" style="color: white; width: 28px; height: 28px;"></i>
              </div>
              <h4 style="font-size: 1.125rem; font-weight: 600; color: var(--gray-900); margin-bottom: 0.5rem;" data-translate="reliability">الموثوقية</h4>
              <p style="color: var(--gray-600); font-size: 0.875rem;" data-translate="reliabilityDesc">نلتزم بأعلى معايير الجودة والدقة في جميع خدماتنا</p>
            </div>
          @endforelse
        </div>
      </div>
    </div>
  </section>

  <!-- FAQ Section -->
  <section id="faq" class="faq-section" style="background: linear-gradient(to bottom, white, var(--gray-50));">
    <div class="container">
      <div class="section-header">
        <div class="section-badge" data-translate="frequentlyAskedQuestions">الأسئلة الشائعة</div>
        <h2 class="section-title" data-translate="faqTitle">أسئلة يتكرر طرحها</h2>
        <p class="section-description" data-translate="faqDescription">إجابات على الأسئلة الأكثر شيوعاً حول خدماتنا وعملية تخليص عقود الإيجار</p>
      </div>
      
      <div style="max-width: 56rem; margin: 0 auto;">
        @forelse($faqs as $faq)
          <div class="faq-item">
            <button class="faq-button">
              <span class="faq-question">{{ app()->getLocale() == 'ar' ? $faq->question_ar : $faq->question_en }}</span>
              <div class="faq-icon-wrapper">
                <i data-lucide="chevron-down" class="faq-icon"></i>
              </div>
            </button>
            <div class="faq-content">
              <div class="faq-content-inner">{{ app()->getLocale() == 'ar' ? $faq->answer_ar : $faq->answer_en }}</div>
            </div>
          </div>
        @empty
          {{-- Default FAQs if none exist --}}
          <div class="faq-item">
            <button class="faq-button">
              <span class="faq-question">ما هي المستندات المطلوبة لإعداد عقد الإيجار؟</span>
              <div class="faq-icon-wrapper">
                <i data-lucide="chevron-down" class="faq-icon"></i>
              </div>
            </button>
            <div class="faq-content">
              <div class="faq-content-inner">المستندات الأساسية تشمل: نسخة من الهوية الوطنية للمؤجر والمستأجر، صك الملكية أو ما يثبت ملكية العقار، ومعلومات تفصيلية عن العقار المراد تأجيره.</div>
            </div>
          </div>
        @endforelse
      </div>
      
      <div style="margin-top: 3rem; text-align: center;">
        <div style="background: linear-gradient(to bottom right, var(--primary-blue), var(--primary-blue-dark)); border-radius: 1rem; padding: 2rem; color: white;">
          <h3 style="font-size: 1.5rem; font-weight: 600; margin-bottom: 0.75rem;" data-translate="didNotFindAnswer">لم تجد إجابة لسؤالك؟</h3>
          <p style="color: rgba(255, 255, 255, 0.8); margin-bottom: 1.5rem;" data-translate="contactUsDirectly">تواصل معنا مباشرة وسيسعدنا الإجابة على جميع استفساراتك</p>
          <a href="#contact" class="btn-primary" style="background: white; color: var(--primary-blue);" data-translate="contactUsNow">تواصل معنا الآن</a>
        </div>
      </div>
    </div>
  </section>

  <!-- Contact Section -->
  <section id="contact" class="contact-section">
    <div class="container">
      <div class="contact-header">
        <div class="contact-badge" data-translate="contact">تواصل معنا</div>
        <h2 class="contact-title" data-translate="contactUsTitle">نحن هنا لمساعدتك</h2>
        <p class="contact-description" data-translate="contactDescription">تواصل معنا عبر أي من القنوات التالية وسنكون سعداء بخدمتك</p>
      </div>
      
      <div class="contact-grid">
        <!-- Phone Numbers -->
        <div class="contact-card">
          <div class="contact-card-header">
            <div class="contact-icon-wrapper contact-icon-phone">
              <i data-lucide="phone" class="contact-icon"></i>
            </div>
            <h3 class="contact-card-title" data-translate="phoneNumbers">أرقام الهاتف</h3>
          </div>
          <div class="contact-list">
            @forelse($contactInfo->phones ?? [] as $phone)
              @php
                // Handle both array format (string) and object format
                $phoneNumber = is_string($phone) ? $phone : ($phone['number'] ?? '');
              @endphp
              @if($phoneNumber)
                <div class="contact-item">
                  <a href="tel:{{ $phoneNumber }}" class="contact-item-value contact-phone" dir="ltr" style="display: block; padding: 0.5rem 0;">{{ $phoneNumber }}</a>
                </div>
              @endif
            @empty
              <div class="contact-item">
                <a href="tel:+966501234567" class="contact-item-value contact-phone" dir="ltr" style="display: block; padding: 0.5rem 0;">+966 50 123 4567</a>
              </div>
            @endforelse
          </div>
        </div>
        
        <!-- Emails -->
        <div class="contact-card">
          <div class="contact-card-header">
            <div class="contact-icon-wrapper contact-icon-email">
              <i data-lucide="mail" class="contact-icon"></i>
            </div>
            <h3 class="contact-card-title" data-translate="email">البريد الإلكتروني</h3>
          </div>
          <div class="contact-list">
            @forelse($contactInfo->emails ?? [] as $email)
              @php
                // Handle both array format (string) and object format
                $emailAddress = is_string($email) ? $email : ($email['address'] ?? '');
              @endphp
              @if($emailAddress)
                <div class="contact-item">
                  <a href="mailto:{{ $emailAddress }}" class="contact-item-value contact-email" style="display: block; padding: 0.5rem 0;">{{ $emailAddress }}</a>
                </div>
              @endif
            @empty
              <div class="contact-item">
                <a href="mailto:info@ijarah.com" class="contact-item-value contact-email" style="display: block; padding: 0.5rem 0;">info@ijarah.com</a>
              </div>
            @endforelse
          </div>
        </div>
        
        <!-- Locations -->
        <div class="contact-card">
          <div class="contact-card-header">
            <div class="contact-icon-wrapper contact-icon-location">
              <i data-lucide="map-pin" class="contact-icon"></i>
            </div>
            <h3 class="contact-card-title" data-translate="ourLocations">مواقعنا</h3>
          </div>
          <div class="contact-list">
            @forelse($contactInfo->addresses ?? [] as $address)
              @php
                $addressText = app()->getLocale() == 'ar' ? ($address['address_ar'] ?? '') : ($address['address_en'] ?? '');
              @endphp
              @if($addressText)
                <div class="contact-location-item">
                  <div class="contact-location-address">{{ $addressText }}</div>
                </div>
              @endif
            @empty
              <div class="contact-location-item">
                <div class="contact-location-address" data-translate="riyadhAddress">شارع الملك فهد، حي العليا</div>
              </div>
            @endforelse
          </div>
        </div>
        
        <!-- Social Media & Working Hours -->
        <div class="contact-right-column">
          <!-- Social Media -->
          <div class="contact-card">
            <div class="contact-card-header">
              <div class="contact-icon-wrapper contact-icon-social">
                <i data-lucide="globe" class="contact-icon"></i>
              </div>
              <h3 class="contact-card-title" data-translate="socialMedia">وسائل التواصل</h3>
            </div>
            <div class="social-grid">
              @if($contactInfo->facebook)
                <a href="{{ $contactInfo->facebook }}" target="_blank" class="social-card social-facebook">
                  <i data-lucide="facebook" class="social-icon"></i>
                  <span class="social-name">Facebook</span>
                </a>
              @endif
              @if($contactInfo->instegram)
                <a href="{{ $contactInfo->instegram }}" target="_blank" class="social-card social-instagram">
                  <i data-lucide="instagram" class="social-icon"></i>
                  <span class="social-name">Instagram</span>
                </a>
              @endif
              @if($contactInfo->linkedin)
                <a href="{{ $contactInfo->linkedin }}" target="_blank" class="social-card social-linkedin">
                  <i data-lucide="linkedin" class="social-icon"></i>
                  <span class="social-name">LinkedIn</span>
                </a>
              @endif
              @if($contactInfo->youtube)
                <a href="{{ $contactInfo->youtube }}" target="_blank" class="social-card social-youtube">
                  <i data-lucide="youtube" class="social-icon"></i>
                  <span class="social-name">YouTube</span>
                </a>
              @endif
              @if($contactInfo->threads)
                <a href="{{ $contactInfo->threads }}" target="_blank" class="social-card social-twitter">
                  <i data-lucide="message-circle" class="social-icon"></i>
                  <span class="social-name">Threads</span>
                </a>
              @endif
              @if($contactInfo->whatsapp)
                <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $contactInfo->whatsapp) }}" target="_blank" class="social-card" style="background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);">
                  <i data-lucide="message-circle" class="social-icon"></i>
                  <span class="social-name">WhatsApp</span>
                </a>
              @endif
            </div>
          </div>
          
          <!-- Working Hours -->
          <div class="working-hours-card">
            <div class="working-hours-bg"></div>
            <h3 class="working-hours-title" data-translate="workingHours">ساعات العمل</h3>
            <p class="working-hours-description" data-translate="workingHoursDescription">نحن متاحون لخدمتك في الأوقات التالية</p>
            <div class="working-hours-list">
              @forelse($contactInfo->working_hours ?? [] as $hours)
                @php
                  $workingHoursText = app()->getLocale() == 'ar' ? ($hours['working_hours_ar'] ?? '') : ($hours['working_hours_en'] ?? '');
                @endphp
                @if($workingHoursText)
                  <div class="working-hours-item">
                    <span>{{ $workingHoursText }}</span>
                  </div>
                @endif
              @empty
                <div class="working-hours-item">
                  <span data-translate="satToThu">السبت - الخميس</span>
                  <span dir="ltr">9:00 AM - 9:00 PM</span>
                </div>
                <div class="working-hours-item">
                  <span data-translate="friday">الجمعة</span> 
                  <span dir="ltr">2:00 PM - 9:00 PM</span>
                </div>
              @endforelse
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection