@extends('website.layout.master')
@section('content')

  <!-- Contract Details Section -->
  <section class="details-section">
    <div class="details-container container">
      <!-- Header -->
      <div class="details-header" style="opacity: 0; animation: fadeIn 0.5s ease-in 0s forwards;">
        <a href="verify.html" class="back-button">
          <i data-lucide="arrow-right"></i>
          <span data-translate="back">العودة</span>
        </a>
        
        <div class="details-title-section">
          <div>
            <h1 class="section-title" data-translate="contractDetails">تفاصيل العقد</h1>
            <p style="color: var(--gray-600); margin-top: 0.5rem;">
              <span data-translate="contractNumber">رقم العقد:</span> 
              <span style="color: var(--primary-blue);" id="contract-number">123456</span>
            </p>
          </div>
          
          <div class="status-badge" data-translate="pendingApproval">بانتظار الموافقة</div>
        </div>
      </div>

      <!-- Alert -->
      <div class="detail-card" style="opacity: 0; animation: fadeIn 0.5s ease-in 0.1s forwards; margin-bottom: 2rem; background: #eff6ff; border-color: #bfdbfe;">
        <div style="display: flex; gap: 0.75rem;">
          <i data-lucide="alert-circle" style="width: 20px; height: 20px; color: var(--primary-blue); flex-shrink: 0; margin-top: 0.125rem;"></i>
          <div style="font-size: 0.875rem; color: var(--gray-700);">
            <p data-translate="reviewNote">يرجى مراجعة جميع تفاصيل العقد بعناية قبل الموافقة. بمجرد الموافقة، سيتم إرسال العقد للتوثيق الرسمي.</p>
          </div>
        </div>
      </div>

      <div class="details-grid">
        <!-- Main Content -->
        <div style="display: flex; flex-direction: column; gap: 1.5rem;">
          <!-- Parties Information -->
          <div class="detail-card" style="opacity: 0; animation: fadeIn 0.5s ease-in 0.2s forwards;">
            <h2 class="detail-card-title">
              <i data-lucide="user"></i>
              <span data-translate="contractParties">أطراف العقد</span>
            </h2>
            
            <div class="info-grid">
              <div>
                <h3 style="font-size: 0.875rem; color: var(--gray-500); margin-bottom: 0.75rem;" data-translate="landlord">المؤجر</h3>
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                  <p style="color: var(--gray-900); font-weight: 500;" id="landlord-name">أحمد محمد العبدالله</p>
                  <p style="font-size: 0.875rem; color: var(--gray-600);">
                    <span data-translate="idNumber">رقم الهوية:</span> 
                    <span id="landlord-id">1234567890</span>
                  </p>
                  <p style="font-size: 0.875rem; color: var(--gray-600);" dir="ltr" id="landlord-phone">+966 50 123 4567</p>
                  <p style="font-size: 0.875rem; color: var(--gray-600);" id="landlord-email">ahmed@example.com</p>
                </div>
              </div>
              
              <div>
                <h3 style="font-size: 0.875rem; color: var(--gray-500); margin-bottom: 0.75rem;" data-translate="tenant">المستأجر</h3>
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                  <p style="color: var(--gray-900); font-weight: 500;" id="tenant-name">خالد سعد المطيري</p>
                  <p style="font-size: 0.875rem; color: var(--gray-600);">
                    <span data-translate="idNumber">رقم الهوية:</span> 
                    <span id="tenant-id">0987654321</span>
                  </p>
                  <p style="font-size: 0.875rem; color: var(--gray-600);" dir="ltr" id="tenant-phone">+966 50 987 6543</p>
                  <p style="font-size: 0.875rem; color: var(--gray-600);" id="tenant-email">khaled@example.com</p>
                </div>
              </div>
            </div>
          </div>

          <!-- Property Details -->
          <div class="detail-card" style="opacity: 0; animation: fadeIn 0.5s ease-in 0.3s forwards;">
            <h2 class="detail-card-title">
              <i data-lucide="map-pin"></i>
              <span data-translate="propertyDetails">تفاصيل العقار</span>
            </h2>
            
            <div class="info-grid">
              <div class="info-row">
                <span class="info-label" data-translate="propertyType">نوع العقار</span>
                <span class="info-value" id="property-type">شقة سكنية</span>
              </div>
              <div class="info-row">
                <span class="info-label" data-translate="area">المساحة</span>
                <span class="info-value" id="property-area">150 متر مربع</span>
              </div>
              <div class="info-row">
                <span class="info-label" data-translate="bedrooms">غرف النوم</span>
                <span class="info-value" id="property-bedrooms">3</span>
              </div>
              <div class="info-row">
                <span class="info-label" data-translate="bathrooms">دورات المياه</span>
                <span class="info-value" id="property-bathrooms">2</span>
              </div>
            </div>
            
            <div style="margin-top: 1rem; padding: 1rem; background: var(--gray-50); border-radius: 0.5rem;">
              <p style="font-size: 0.875rem; color: var(--gray-600);" data-translate="location">الموقع</p>
              <p style="color: var(--gray-900); margin-top: 0.25rem;" id="property-location">الرياض، حي العليا، شارع الملك فهد</p>
            </div>
          </div>

          <!-- Contract Terms -->
          <div class="detail-card" style="opacity: 0; animation: fadeIn 0.5s ease-in 0.4s forwards;">
            <h2 class="detail-card-title">
              <i data-lucide="file-text"></i>
              <span data-translate="contractTerms">شروط العقد</span>
            </h2>
            
            <ul class="terms-list" id="contract-terms">
              <li>يلتزم المستأجر بدفع قيمة الإيجار في المواعيد المحددة</li>
              <li>يحظر على المستأجر إجراء أي تعديلات على العقار دون موافقة المؤجر</li>
              <li>يحق للمؤجر زيارة العقار بعد إشعار مسبق بـ 24 ساعة</li>
              <li>المستأجر مسؤول عن صيانة العقار والحفاظ عليه</li>
              <li>يتحمل المستأجر رسوم الكهرباء والماء والخدمات</li>
              <li>لا يحق للمستأجر تأجير العقار من الباطن</li>
            </ul>
          </div>
        </div>

        <!-- Sidebar -->
        <div style="display: flex; flex-direction: column; gap: 1.5rem;">
          <!-- Contract Summary -->
          <div class="summary-card" style="opacity: 0; animation: fadeIn 0.5s ease-in 0.2s forwards;">
            <h3 style="font-size: 1.25rem; font-weight: 600; margin-bottom: 1.5rem;" data-translate="contractSummary">ملخص العقد</h3>
            
            <div style="display: flex; flex-direction: column; gap: 1rem;">
              <div class="summary-item">
                <i data-lucide="calendar"></i>
                <div>
                  <p class="summary-label" data-translate="contractDuration">مدة العقد</p>
                  <p class="summary-value" id="contract-duration">12 شهر</p>
                </div>
              </div>
              
              <div class="summary-item">
                <i data-lucide="dollar-sign"></i>
                <div>
                  <p class="summary-label" data-translate="annualRent">قيمة الإيجار السنوي</p>
                  <p class="summary-value" id="contract-rent">45,000 <span data-translate="riyal">ريال</span></p>
                </div>
              </div>
              
              <div class="summary-item">
                <i data-lucide="dollar-sign"></i>
                <div>
                  <p class="summary-label" data-translate="deposit">مبلغ التأمين</p>
                  <p class="summary-value" id="contract-deposit">5,000 <span data-translate="riyal">ريال</span></p>
                </div>
              </div>
              
              <div class="summary-item" style="border-bottom: none;">
                <i data-lucide="calendar"></i>
                <div>
                  <p class="summary-label" data-translate="startDate">تاريخ البدء</p>
                  <p class="summary-value" id="contract-start-date">2024-01-01</p>
                </div>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="actions-card" style="opacity: 0; animation: fadeIn 0.5s ease-in 0.3s forwards;">
            <button id="approve-btn" class="action-button btn-approve">
              <i data-lucide="check-circle"></i>
              <span data-translate="approveContract">الموافقة على العقد</span>
            </button>
            
            <button id="reject-btn" class="action-button btn-reject">
              <i data-lucide="x-circle"></i>
              <span data-translate="rejectContract">رفض العقد</span>
            </button>
            
            <button id="download-btn" class="action-button btn-download">
              <i data-lucide="download"></i>
              <span data-translate="downloadPDF">تحميل نسخة PDF</span>
            </button>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Confirm Dialog -->
  <div id="confirm-dialog" class="modal hidden">
    <div class="modal-content">
      <div class="confirm-dialog">
        <p class="confirm-message" id="confirm-message-text" data-translate="confirmApproval">هل أنت متأكد من الموافقة على هذا العقد؟</p>
        <div class="confirm-actions">
          <button id="confirm-yes" class="confirm-btn yes" data-translate="yesSure">نعم، متأكد</button>
          <button id="confirm-cancel" class="confirm-btn cancel" data-translate="cancel">إلغاء</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Success Dialog -->
  <div id="success-dialog" class="modal hidden">
    <div class="modal-content">
      <div class="modal-icon success success-icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
          <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
          <polyline points="22 4 12 14.01 9 11.01"></polyline>
        </svg>
      </div>
      
      <h2 class="modal-title success-title" data-translate="approvedSuccessfully">تمت الموافقة بنجاح!</h2>
      
      <p class="modal-message success-message" data-translate="approvalMessage">تم تسجيل موافقتك على العقد. سيتم التواصل معك قريباً لإتمام الإجراءات.</p>

      <div class="modal-actions">
        <a href="index.html" class="btn-primary" data-translate="backToHome">العودة للرئيسية</a>
        <button id="download-contract-btn" class="btn-secondary" style="gap: 0.5rem;">
          <i data-lucide="download"></i>
          <span data-translate="downloadContract">تحميل العقد</span>
        </button>
      </div>
    </div>
  </div>

  <script>
    // Load contract data
    function loadContractData() {
      const urlParams = new URLSearchParams(window.location.search);
      const code = urlParams.get('code') || sessionStorage.getItem('contractCode');
      
      if (!code) {
        window.location.href = 'verify.html';
        return;
      }

      // Mock contract data - same as React component
      const contract = {
        contractNumber: code,
        landlord: {
          name: 'أحمد محمد العبدالله',
          id: '1234567890',
          phone: '+966 50 123 4567',
          email: 'ahmed@example.com',
        },
        tenant: {
          name: 'خالد سعد المطيري',
          id: '0987654321',
          phone: '+966 50 987 6543',
          email: 'khaled@example.com',
        },
        property: {
          type: 'شقة سكنية',
          location: 'الرياض، حي العليا، شارع الملك فهد',
          area: '150 متر مربع',
          bedrooms: 3,
          bathrooms: 2,
        },
        contract: {
          startDate: '2024-01-01',
          duration: '12 شهر',
          rentAmount: '45,000',
          deposit: '5,000',
        },
      };

      // Populate contract data
      document.getElementById('contract-number').textContent = contract.contractNumber;
      document.getElementById('landlord-name').textContent = contract.landlord.name;
      document.getElementById('landlord-id').textContent = contract.landlord.id;
      document.getElementById('landlord-phone').textContent = contract.landlord.phone;
      document.getElementById('landlord-email').textContent = contract.landlord.email;
      document.getElementById('tenant-name').textContent = contract.tenant.name;
      document.getElementById('tenant-id').textContent = contract.tenant.id;
      document.getElementById('tenant-phone').textContent = contract.tenant.phone;
      document.getElementById('tenant-email').textContent = contract.tenant.email;
      document.getElementById('property-type').textContent = contract.property.type;
      document.getElementById('property-area').textContent = contract.property.area;
      document.getElementById('property-bedrooms').textContent = contract.property.bedrooms;
      document.getElementById('property-bathrooms').textContent = contract.property.bathrooms;
      document.getElementById('property-location').textContent = contract.property.location;
      document.getElementById('contract-duration').textContent = contract.contract.duration;
      document.getElementById('contract-rent').textContent = contract.contract.rentAmount;
      document.getElementById('contract-deposit').textContent = contract.contract.deposit;
      document.getElementById('contract-start-date').textContent = contract.contract.startDate;

      // Update icons after content load
      setTimeout(() => {
        if (typeof lucide !== 'undefined' && lucide.createIcons) {
          lucide.createIcons();
        }
      }, 100);
    }

    // Handle download button
    function setupDownloadButtons() {
      const downloadBtn = document.getElementById('download-btn');
      if (downloadBtn) {
        downloadBtn.addEventListener('click', () => {
          // Download PDF functionality would go here
          console.log('Download PDF');
        });
      }

      const downloadContractBtn = document.getElementById('download-contract-btn');
      if (downloadContractBtn) {
        downloadContractBtn.addEventListener('click', () => {
          // Download PDF functionality would go here
          console.log('Download Contract PDF');
        });
      }
    }

    // Initialize everything when DOM is ready
    document.addEventListener('DOMContentLoaded', () => {
      // Set current year
      const currentYearEl = document.getElementById('current-year');
      if (currentYearEl) {
        currentYearEl.textContent = new Date().getFullYear();
      }

      // Load contract data
      loadContractData();
      
      // Setup download buttons
      setupDownloadButtons();

      // Re-initialize icons after content is loaded
      setTimeout(() => {
        if (typeof lucide !== 'undefined' && lucide.createIcons) {
          lucide.createIcons();
        }
      }, 200);
    });
  </script>
@endsection