<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // إنشاء الأدوار
        $adminRole = Role::firstOrCreate(
            [
                'name' => 'الأدمن',
                'guard_name' => 'api',
            ]
        );

        $employeeRole = Role::firstOrCreate(
            [
                'name' => 'الموظف',
                'guard_name' => 'api',
            ]
        );

        $clientRole = Role::firstOrCreate(
            [
                'name' => 'العميل',
                'guard_name' => 'api',
            ]
        );

        // إعطاء دور الأدمن كل الصلاحيات
        $allPermissions = Permission::all();
        $adminRole->syncPermissions($allPermissions);

        $this->command->info('تم إنشاء الأدوار بنجاح!');
        $this->command->info('تم إعطاء دور الأدمن كل الصلاحيات (' . $allPermissions->count() . ' صلاحية)');
    }
}
