<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // مسح الصلاحيات الموجودة (اختياري - يمكن حذف هذا السطر إذا كنت تريد الاحتفاظ بالصلاحيات الموجودة)
        // Permission::truncate();

        // إنشاء الصلاحيات
        $permissions = [
            'إدارة المستخدمين',
            'إدارة البيانات العامة',
            'إدارة بيانات التواصل',
            'إدارة العقود',
            'إدارة الإعدادات',
            'إدارة المدن والمناطق',
            'إدارة الأسئلة الشائعة',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                [
                    'name' => $permission,
                    'guard_name' => 'api',
                ]
            );
        }

        $this->command->info('تم إنشاء الصلاحيات بنجاح!');
    }
}
