<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\Zone;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class EgyptCitiesZonesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // بيانات المدن والمناطق في مصر
        $citiesData = [
            // القاهرة
            [
                'name_ar' => 'القاهرة',
                'name_en' => 'Cairo',
                'zones' => [
                    ['name_ar' => 'وسط البلد', 'name_en' => 'Downtown'],
                    ['name_ar' => 'الزمالك', 'name_en' => 'Zamalek'],
                    ['name_ar' => 'المعادي', 'name_en' => 'Maadi'],
                    ['name_ar' => 'النزهة', 'name_en' => 'El Nozha'],
                    ['name_ar' => 'مصر الجديدة', 'name_en' => 'New Cairo'],
                    ['name_ar' => 'المهندسين', 'name_en' => 'Mohandessin'],
                    ['name_ar' => 'الدقي', 'name_en' => 'Dokki'],
                    ['name_ar' => 'الزيتون', 'name_en' => 'Zeitoun'],
                    ['name_ar' => 'شبرا', 'name_en' => 'Shubra'],
                    ['name_ar' => 'حلوان', 'name_en' => 'Helwan'],
                    ['name_ar' => 'المقطم', 'name_en' => 'Mokattam'],
                    ['name_ar' => 'مدينة نصر', 'name_en' => 'Nasr City'],
                    ['name_ar' => 'الشروق', 'name_en' => 'El Shorouk'],
                    ['name_ar' => '6 أكتوبر', 'name_en' => '6th of October'],
                ],
            ],
            // الإسكندرية
            [
                'name_ar' => 'الإسكندرية',
                'name_en' => 'Alexandria',
                'zones' => [
                    ['name_ar' => 'المنتزه', 'name_en' => 'Montaza'],
                    ['name_ar' => 'سيدي بشر', 'name_en' => 'Sidi Bishr'],
                    ['name_ar' => 'سيدي جابر', 'name_en' => 'Sidi Gaber'],
                    ['name_ar' => 'الرمل', 'name_en' => 'El Raml'],
                    ['name_ar' => 'الشاطبي', 'name_en' => 'Shatby'],
                    ['name_ar' => 'محرم بك', 'name_en' => 'Moharam Bek'],
                    ['name_ar' => 'كفر عبده', 'name_en' => 'Kafr Abdo'],
                    ['name_ar' => 'سموحة', 'name_en' => 'Smouha'],
                    ['name_ar' => 'ستانلي', 'name_en' => 'Stanley'],
                    ['name_ar' => 'رشدي', 'name_en' => 'Roushdy'],
                ],
            ],
            // الجيزة
            [
                'name_ar' => 'الجيزة',
                'name_en' => 'Giza',
                'zones' => [
                    ['name_ar' => 'الهرم', 'name_en' => 'Pyramids'],
                    ['name_ar' => 'أوسيم', 'name_en' => 'Ossim'],
                    ['name_ar' => 'الوراق', 'name_en' => 'Warraq'],
                    ['name_ar' => 'إمبابة', 'name_en' => 'Imbaba'],
                    ['name_ar' => 'البدرشين', 'name_en' => 'Badrasheen'],
                    ['name_ar' => 'أبو النمرس', 'name_en' => 'Abu Nomros'],
                    ['name_ar' => 'كرداسة', 'name_en' => 'Kerdasa'],
                ],
            ],
            // المنصورة
            [
                'name_ar' => 'المنصورة',
                'name_en' => 'Mansoura',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'جامعة المنصورة', 'name_en' => 'Mansoura University'],
                    ['name_ar' => 'كفر البطيخ', 'name_en' => 'Kafr El Battikh'],
                ],
            ],
            // طنطا
            [
                'name_ar' => 'طنطا',
                'name_en' => 'Tanta',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'الساحة', 'name_en' => 'El Saha'],
                ],
            ],
            // أسيوط
            [
                'name_ar' => 'أسيوط',
                'name_en' => 'Assiut',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'جامعة أسيوط', 'name_en' => 'Assiut University'],
                ],
            ],
            // الإسماعيلية
            [
                'name_ar' => 'الإسماعيلية',
                'name_en' => 'Ismailia',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'القنطرة', 'name_en' => 'El Qantara'],
                ],
            ],
            // الأقصر
            [
                'name_ar' => 'الأقصر',
                'name_en' => 'Luxor',
                'zones' => [
                    ['name_ar' => 'الأقصر الجديدة', 'name_en' => 'New Luxor'],
                    ['name_ar' => 'طيبة الجديدة', 'name_en' => 'New Thebes'],
                ],
            ],
            // أسوان
            [
                'name_ar' => 'أسوان',
                'name_en' => 'Aswan',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'السد العالي', 'name_en' => 'High Dam'],
                ],
            ],
            // بني سويف
            [
                'name_ar' => 'بني سويف',
                'name_en' => 'Beni Suef',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
            // المنيا
            [
                'name_ar' => 'المنيا',
                'name_en' => 'Minya',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'جامعة المنيا', 'name_en' => 'Minya University'],
                ],
            ],
            // السويس
            [
                'name_ar' => 'السويس',
                'name_en' => 'Suez',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'الأربعين', 'name_en' => 'Arbaeen'],
                ],
            ],
            // بورسعيد
            [
                'name_ar' => 'بورسعيد',
                'name_en' => 'Port Said',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'المناخ', 'name_en' => 'El Manakh'],
                ],
            ],
            // دمياط
            [
                'name_ar' => 'دمياط',
                'name_en' => 'Damietta',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                    ['name_ar' => 'رأس البر', 'name_en' => 'Ras El Bar'],
                ],
            ],
            // قنا
            [
                'name_ar' => 'قنا',
                'name_en' => 'Qena',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
            // الزقازيق
            [
                'name_ar' => 'الزقازيق',
                'name_en' => 'Zagazig',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
            // دمنهور
            [
                'name_ar' => 'دمنهور',
                'name_en' => 'Damanhur',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
            // كفر الشيخ
            [
                'name_ar' => 'كفر الشيخ',
                'name_en' => 'Kafr El Sheikh',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
            // شبين الكوم
            [
                'name_ar' => 'شبين الكوم',
                'name_en' => 'Shebin El Kom',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
            // المنيا الجديدة
            [
                'name_ar' => 'المنيا الجديدة',
                'name_en' => 'New Minya',
                'zones' => [
                    ['name_ar' => 'وسط المدينة', 'name_en' => 'City Center'],
                ],
            ],
        ];

        $totalCities = 0;
        $totalZones = 0;

        foreach ($citiesData as $cityData) {
            // التحقق من وجود المدينة أو إنشائها
            $city = City::firstOrCreate(
                [
                    'name_ar' => $cityData['name_ar'],
                ],
                [
                    'name_en' => $cityData['name_en'],
                ]
            );

            if ($city->wasRecentlyCreated) {
                $totalCities++;
            }

            // إضافة المناطق للمدينة
            foreach ($cityData['zones'] as $zoneData) {
                $zone = Zone::firstOrCreate(
                    [
                        'name_ar' => $zoneData['name_ar'],
                        'city_id' => $city->id,
                    ],
                    [
                        'name_en' => $zoneData['name_en'],
                    ]
                );

                if ($zone->wasRecentlyCreated) {
                    $totalZones++;
                }
            }
        }

        $this->command->info("تم إضافة المدن والمناطق المصرية بنجاح!");
        $this->command->info("عدد المدن المضافة: {$totalCities}");
        $this->command->info("عدد المناطق المضافة: {$totalZones}");
        $this->command->info("إجمالي المدن: " . City::count());
        $this->command->info("إجمالي المناطق: " . Zone::count());
    }
}
