<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // تشغيل seeders بالترتيب الصحيح
        $this->call([
            PermissionsSeeder::class,  // أولاً: إنشاء الصلاحيات
            RolesSeeder::class,        // ثانياً: إنشاء الأدوار وإعطاء الصلاحيات
            AdminUserSeeder::class,    // ثالثاً: إنشاء مستخدم الأدمن
            // EgyptCitiesZonesSeeder::class,  // رابعاً: إضافة مدن ومناطق مصر (اختياري - قم بإلغاء التعليق لتشغيله)
        ]);

        // User::factory(10)->create();

        // User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);
    }
}
