<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // التحقق من وجود المستخدم بالفعل
        $admin = User::where('email', 'admin@ejar.com')->first();

        if ($admin) {
            $this->command->warn('المستخدم admin@ejar.com موجود بالفعل!');
            return;
        }

        // إنشاء مستخدم الأدمن
        $admin = User::create([
            'name' => 'أدمن',
            'middle_name' => 'النظام',
            'third_name' => '',
            'last_name' => '',
            'email' => 'admin@ejar.com',
            'phone' => '0500000000',
            'whatsapp' => '0500000001',
            'password' => Hash::make('password'), // كلمة المرور الافتراضية: password
            'type' => 'user',
            'status' => 'active',
            'is_verified' => true,
        ]);

        // إعطاء دور الأدمن
        $adminRole = Role::where('name', 'الأدمن')->where('guard_name', 'api')->first();
        if ($adminRole) {
            $admin->assignRole($adminRole);
            $this->command->info('تم إنشاء مستخدم الأدمن بنجاح!');
            $this->command->info('البريد الإلكتروني: admin@ejar.com');
            $this->command->info('كلمة المرور: password');
            $this->command->warn('⚠️  يرجى تغيير كلمة المرور بعد تسجيل الدخول!');
        } else {
            $this->command->error('لم يتم العثور على دور الأدمن! يرجى تشغيل RolesSeeder أولاً.');
        }
    }
}
