<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profile_update_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            
            // البيانات المطلوبة للتحديث (JSON لتخزين جميع الحقول)
            $table->json('requested_data');
            
            // البيانات الحالية قبل التحديث (للرجوع إليها)
            $table->json('current_data')->nullable();
            
            // حالة الطلب: pending, approved, rejected
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            
            // من راجع الطلب (admin user id)
            $table->foreignId('reviewed_by')->nullable()->constrained('users')->onDelete('set null');
            
            // ملاحظات المراجعة
            $table->text('review_notes')->nullable();
            
            $table->timestamp('reviewed_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'status']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profile_update_requests');
    }
};
