<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // إضافة حقل نوع الهوية
        Schema::table('users', function (Blueprint $table) {
            $table->enum('id_type', ['national', 'resident', 'passport'])->nullable()->after('national_id');
        });
        
        // تعديل email ليكون nullable (اختياري)
        Schema::table('users', function (Blueprint $table) {
            $table->string('email')->nullable()->change();
        });
        
        // تعديل حقل type - يجب استخدام DB::statement لأن Laravel لا يدعم تعديل enum مباشرة
        \Illuminate\Support\Facades\DB::statement("ALTER TABLE users MODIFY COLUMN type ENUM('landlord', 'tenant','user) DEFAULT 'user'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // حذف حقل id_type
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('id_type'); 
        });
        
        // إعادة type للقيم القديمة
        \Illuminate\Support\Facades\DB::statement("ALTER TABLE users MODIFY COLUMN type 
        ENUM('user', 'client') DEFAULT 'user'");
        
        // إعادة email ليكون required
        Schema::table('users', function (Blueprint $table) {
            $table->string('email')->nullable(false)->change();
        });
    }
};
