<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_infos', function (Blueprint $table) {
            $table->text('message_en')->nullable()->after('about_us_ar');
            $table->text('message_ar')->nullable()->after('about_us_ar');
            $table->text('vision_en')->nullable()->after('message_ar');
            $table->text('vision_ar')->nullable()->after('message_ar');
            $table->text('values_en')->nullable()->after('vision_ar');
            $table->text('values_ar')->nullable()->after('vision_ar');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_infos', function (Blueprint $table) {
            $table->dropColumn(['message_en', 'message_ar', 'vision_en', 'vision_ar', 'values_en', 'values_ar']);
        });
    }
};
