<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contracts', function (Blueprint $table) {
            $table->id();
                $table->foreignId('created_by_id')->constrained('users');
                $table->foreignId('employee_id')->constrained('users');
                $table->foreignId('assigned_by_id')->constrained('users');
                $table->foreignId('deleted_by_id')->constrained('users');
             $table->string('contract_number');
             $table->string('contract_type');
             $table->string('contract_date');
             $table->string('contract_duration');
             $table->string('contract_amount');
             $table->boolean('is_active')->default(true);
             $table->enum('contract_status', ['pending','draft', 'approved', 'rejected','cancelled'])->default('pending');
             $table->string('contract_qrcode');
             $table->text('contract_text');
             $table->string('contract_notes');
             $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contracts');
    }
};
