<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('middle_name');
            $table->string('third_name');
            $table->string('last_name');
            $table->string('national_id')->nullable()->unique();         
            $table->string('email')->unique();
            $table->string('nationality')->nullable();
            $table->string('phone')->unique();
            $table->string('whatsapp')->unique();
            $table->string('address')->nullable();
            $table->foreignId('city_id')->nullable()->constrained('cities');
            $table->foreignId('zone_id')->nullable()->constrained('zones');
            $table->string('zip')->nullable();
            $table->boolean('is_verified')->default(false);
            $table->enum('type', ['user', 'client'])->default('user');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->date('otp_code_expires_at')->nullable();
            $table->string('otp_code')->nullable();
            $table->string('otp_code_verified_at')->nullable();
            $table->date('last_login_at')->nullable();
            $table->string('try_login_count')->default(0);
            $table->string('last_try_login_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
