<?php

namespace App\Traits;

use Twilio\Rest\Client;

trait TwilioTrait
{
    public function SendSms($user, $otp)
    {
        $account_sid = env('TWILIO_SID');
        $auth_token = env('TWILIO_AUTH_TOKEN');
        $twilio_number = env('TWILIO_NUMBER');
        
        // التحقق من وجود البيانات المطلوبة
        if (!$account_sid || !$auth_token || !$twilio_number) {
            throw new \Exception('Twilio credentials are not configured properly. Please check TWILIO_SID, TWILIO_AUTH_TOKEN, and TWILIO_NUMBER in .env file');
        }
        
        $client = new Client($account_sid, $auth_token);
        
        // تحديد اللغة والرسالة
        $locale = app()->getLocale();
        $message = $locale == 'en' 
            ? 'Hello ' . $user->name . ' Your Verification Code is ' . $otp 
            : 'مرحبا ' . $user->name . ' كود التفعيل الخاص بك هو ' . $otp;
        
        try {
            $client->messages->create(
                $user->phone,
                ['from' => $twilio_number, 'body' => $message]
            );
        } catch (\Twilio\Exceptions\RestException $e) {
            // تحسين رسالة الخطأ
            $errorMessage = $e->getMessage();
            $statusCode = $e->getStatusCode();
            
            // معالجة أخطاء محددة
            if (strpos($errorMessage, 'Alphanumeric Sender ID') !== false) {
                throw new \Exception('Alphanumeric Sender ID "' . $twilio_number . '" is not registered or approved in your Twilio account. Please register it at: https://console.twilio.com/us1/develop/sms/sender-ids or use a valid Twilio phone number (e.g., +1234567890)');
            }
            
            // إرجاع رسالة الخطأ الأصلية من Twilio
            throw new \Exception('Twilio SMS Error (' . $statusCode . '): ' . $errorMessage);
        }
    }   
}
