<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, HasApiTokens, HasRoles;
    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'middle_name',
        'third_name',
        'last_name',
        'national_id',
        'id_type',
        'phone',
        'whatsapp',
        'address',
        'city_id',
        'zone_id',
        'nationality',
        'is_verified',
        'type',
        'status',
        'gender',
        'otp_code_expires_at',
        'otp_code',
        'otp_code_verified_at',
        'last_login_at',
        'try_login_count',
        'last_try_login_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }
    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }
    public function contracts()
    {
        return $this->hasMany(Contract::class);
    }
    public function createdContracts()
    {
        return $this->hasMany(Contract::class, 'created_by_id');
    }
    public function employeeContracts()
    {
        return $this->hasMany(Contract::class, 'employee_id');
    }
    public function assignedContracts()
    {   
        return $this->hasMany(Contract::class, 'assigned_by_id');
    }
    public function deletedContracts()
    {
        return $this->hasMany(Contract::class, 'deleted_by_id');
    }
    public function notifications()
    {
        return $this->hasMany(Notification::class);
    }
    public function contactInfos()
    {
        return $this->hasMany(ContactInfo::class);
    }
    
    public function passwordResetOtps()
    {
        return $this->hasMany(PasswordResetOtp::class);
    }
    
    public function profileUpdateRequests()
    {
        return $this->hasMany(ProfileUpdateRequest::class);
    }
    
    // Note: roles() and permissions() relationships are provided by HasRoles trait from Spatie Permission
    // No need to define them manually as they use model_has_roles and model_has_permissions tables
    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'otp_code_expires_at' => 'datetime',
            'otp_code_verified_at' => 'datetime',
            'last_login_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
}
