<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = ['logo', 'icon', 'favicon', 'app_name_en', 
    'app_name_ar', 'app_description_en', 'app_description_ar', 
    'seo_title_en', 'seo_title_ar', 'seo_description_en',
     'seo_description_ar', 'seo_keywords_en', 'seo_keywords_ar'];
    public function getAppNameAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->app_name_ar : $this->app_name_en;
    }
    public function getAppDescriptionAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->app_description_ar : $this->app_description_en;
    }
    public function getSeoTitleAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->seo_title_ar : $this->seo_title_en;
    }
    public function getSeoDescriptionAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->seo_description_ar : $this->seo_description_en;
    }
    public function getSeoKeywordsAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->seo_keywords_ar : $this->seo_keywords_en;
    }
}
