<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $fillable = ['user_id', 'contact_info_id', 
    'title_ar', 'title_en', 'description_ar', 'description_en', 
    'link', 'is_deleted', 'is_read', 'type'];
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function contactInfo()
    {
        return $this->belongsTo(ContactInfo::class);
    }
    public function getTitleAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->title_ar : $this->title_en;
    }
    public function getDescriptionAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->description_ar : $this->description_en;
    }

}
