<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GeneralInfo extends Model
{
    protected $fillable = [ 'contracts_counter',
     'support_time', 'experience_years', 'happy_clients', 'success_partners',
     'terms_and_conditions_en', 'terms_and_conditions_ar',
      'privacy_policy_en', 'privacy_policy_ar',
     'about_us_en', 'about_us_ar',
     'message_en', 'message_ar',
     'vision_en', 'vision_ar',
     'values_en', 'values_ar',
      'working_steps_en', 'working_steps_ar', 
      'features_en', 'features_ar',
     'services_en', 'services_ar'];
    public function getTermsAndConditionsAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->terms_and_conditions_ar : $this->terms_and_conditions_en;
    }
    public function getPrivacyPolicyAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->privacy_policy_ar :
         $this->privacy_policy_en;
}

public function getAboutUsAttribute()
{
    return app()->getLocale() == 'ar' ? $this->about_us_ar : $this->about_us_en;
}
public function getWorkingStepsAttribute()
{
    return app()->getLocale() == 'ar' ? $this->working_steps_ar : $this->working_steps_en;
}
public function getFeaturesAttribute()
{
    return app()->getLocale() == 'ar' ? $this->features_ar : $this->features_en;
}
public function getServicesAttribute()
{
    return app()->getLocale() == 'ar' ? $this->services_ar : $this->services_en;
}

/**
 * Get the attributes that should be cast.
 *
 * @return array<string, string>
 */
protected function casts(): array
{
    return [
        'services_en' => 'array',
        'services_ar' => 'array',
        'features_en' => 'array',
        'features_ar' => 'array',
        'working_steps_en' => 'array',
        'working_steps_ar' => 'array',
        'values_en' => 'array',
        'values_ar' => 'array',
    ];
}
}