<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Contract extends Model
{
    protected $fillable = [
        'created_by_id',
        'employee_id',
        'assigned_by_id',
        'deleted_by_id',
        'contract_number',
        'contract_type',
        'contract_date',
        'contract_duration',
        'contract_amount',
        'is_active',
        'contract_status',
        'contract_qrcode',
        'contract_text',
        'contract_notes',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'contract_date' => 'date',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * المستخدم الذي أنشأ العقد
     */
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by_id');
    }

    /**
     * موظف العقد
     */
    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }

    /**
     * المستخدم الذي عين العقد
     */
    public function assignedBy()
    {
        return $this->belongsTo(User::class, 'assigned_by_id');
    }

    /**
     * المستخدم الذي حذف العقد
     */
    public function deletedBy()
    {
        return $this->belongsTo(User::class, 'deleted_by_id');
    }
}
