<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    
    protected $fillable = ['name_ar', 'name_en'];
    public function getNameAttribute()
    {
        return app()->getLocale() == 'ar' ? $this->name_ar : $this->name_en;
    }
    public function zones()
    {
        return $this->hasMany(Zone::class);
    }
    public function users()
    {
        return $this->hasMany(User::class);
    }
}
