<?php

namespace App\Http\Traits;

use Illuminate\Http\JsonResponse;

trait ApiResponse
{
    /**
     * إرجاع استجابة نجاح
     *
     * @param mixed $data
     * @param string $message
     * @param int $statusCode
     * @return JsonResponse
     */
    protected function successResponse($data = null, string $message = '', int $statusCode = 200): JsonResponse
    {
        $response = [
            'success' => true,
            'message' => $message ?: __('messages.success'),
            'data' => $data,
        ];

        return response()->json($response, $statusCode);
    }

    /**
     * إرجاع استجابة خطأ
     *
     * @param string $message
     * @param int $statusCode
     * @param array $errors
     * @return JsonResponse
     */
    protected function errorResponse(string $message = '', int $statusCode = 400, array $errors = []): JsonResponse
    {
        $response = [
            'success' => false,
            'message' => $message ?: __('messages.error'),
            'errors' => $errors,
        ];

        return response()->json($response, $statusCode);
    }

    /**
     * إرجاع استجابة التحقق من البيانات
     *
     * @param array $errors
     * @param string $message
     * @return JsonResponse
     */
    protected function validationErrorResponse(array $errors, string $message = ''): JsonResponse
    {
        return $this->errorResponse(
            $message ?: __('messages.validation_error'),
            422,
            $errors
        );
    }

    /**
     * إرجاع استجابة غير مصرح بها
     *
     * @param string $message
     * @return JsonResponse
     */
    protected function unauthorizedResponse(string $message = ''): JsonResponse
    {
        return $this->errorResponse(
            $message ?: __('messages.unauthorized'),
            401
        );
    }

    /**
     * إرجاع استجابة غير موجود
     *
     * @param string $message
     * @return JsonResponse
     */
    protected function notFoundResponse(string $message = ''): JsonResponse
    {
        return $this->errorResponse(
            $message ?: __('messages.not_found'),
            404
        );
    }
}
