<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // الحصول على اللغة من Session، أو استخدام اللغة الافتراضية
        $locale = Session::get('locale', 'ar');
        
        // تعيين اللغة في Laravel
        App::setLocale($locale);
        
        // إضافة اللغة إلى البيانات المشتركة مع جميع الـ views
        view()->share('currentLocale', $locale);

        return $next($request);
    }
}
