<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Symfony\Component\HttpFoundation\Response;

class ApiLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // الحصول على اللغة من header Accept-Language أو query parameter
        $locale = $request->header('Accept-Language') 
            ?: $request->query('locale') 
            ?: 'ar'; // اللغة الافتراضية

        // التحقق من أن اللغة مدعومة
        $supportedLocales = ['ar', 'en'];
        if (!in_array($locale, $supportedLocales)) {
            $locale = 'ar';
        }

        // تعيين اللغة في Laravel
        App::setLocale($locale);

        return $next($request);
    }
}
