<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\GeneralInfo;
use App\Models\ContactInfo;
use App\Models\FAQ;
use App\Models\Setting;

class WebsiteController extends Controller
{

    public function home()  {
        // جلب البيانات العامة
        $generalInfo = GeneralInfo::first();
        if (!$generalInfo) {
            $generalInfo = GeneralInfo::create([
                'contracts_counter' => '0',
                'support_time' => '24',
                'experience_years' => '0',
                'happy_clients' => '0',
                'success_partners' => '0',
                'services_en' => [],
                'services_ar' => [],
                'features_en' => [],
                'features_ar' => [],
                'working_steps_en' => [],
                'working_steps_ar' => [],
                'values_en' => [],
                'values_ar' => [],
                'about_us_en' => '',
                'about_us_ar' => '',
                'vision_en' => '',
                'vision_ar' => '',
                'message_en' => '',
                'message_ar' => '',
            ]);
        }

        // جلب معلومات التواصل
        $contactInfo = ContactInfo::first();
        if (!$contactInfo) {
            $contactInfo = ContactInfo::create([
                'phones' => [],
                'emails' => [],
                'addresses' => [],
                'working_hours' => [],
                'facebook' => null,
                'whatsapp' => null,
                'instegram' => null,
                'linkedin' => null,
                'youtube' => null,
                'threads' => null,
            ]);
        }

        // جلب الأسئلة الشائعة
        $faqs = FAQ::orderBy('created_at', 'desc')->get();

        // جلب إعدادات الموقع
        $settings = Setting::first();

        return view('website.home', compact('generalInfo', 'contactInfo', 'faqs', 'settings'));
    }

    public function terms()  {
        $generalInfo = GeneralInfo::first();
        if (!$generalInfo) {
            $generalInfo = GeneralInfo::create([
                'terms_and_conditions_en' => '',
                'terms_and_conditions_ar' => '',
            ]);
        }
        return view('website.terms', compact('generalInfo'));
    }
    public function privacyPolicy()  {
        $generalInfo = GeneralInfo::first();
        if (!$generalInfo) {
            $generalInfo = GeneralInfo::create([
                'privacy_policy_en' => '',
                'privacy_policy_ar' => '',
            ]);
        }
        return view('website.privacyPolicy', compact('generalInfo'));
    }

    public function verify()  {
        return view('website.verify');
    }
    
    public function contract()  {
        return view('website.contract');
    }
    
    
    
    
}
